/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.core.container;

import com.yollo.dmlreforged.common.items.ItemDataModel;
import com.yollo.dmlreforged.common.items.ItemDeepLearner;
import com.yollo.dmlreforged.core.init.ContainerInit;
import com.yollo.dmlreforged.core.init.ItemInit;
import com.yollo.dmlreforged.core.util.ItemBackedInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DeepLearnerContainer
extends AbstractContainerMenu {
    protected Player player;
    protected InteractionHand usedHand;
    protected ItemStack deepLearner;
    public final Container deepLearnerInv;

    public static DeepLearnerContainer fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buf) {
        InteractionHand hand = buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        return new DeepLearnerContainer(windowId, inv, inv.f_35978_.m_21120_(hand));
    }

    public DeepLearnerContainer(int id, Inventory playerInv, ItemStack deepLearner) {
        super((MenuType)ContainerInit.DEEP_LEARNER.get(), id);
        ItemStack heldItem;
        ContainerLevelAccess.m_39289_((Level)playerInv.f_35978_.f_19853_, (BlockPos)BlockPos.f_121853_);
        this.player = playerInv.f_35978_;
        this.usedHand = this.player.m_21205_().m_41720_() instanceof ItemDeepLearner ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.deepLearner = heldItem = this.player.m_21205_().m_41720_() instanceof ItemDeepLearner ? this.player.m_21205_() : this.player.m_21206_();
        this.deepLearner = deepLearner;
        this.deepLearnerInv = !playerInv.f_35978_.f_19853_.f_46443_ ? ItemDeepLearner.getInventory(deepLearner) : new ItemBackedInventory(deepLearner, 4);
        this.addInventorySlots();
        this.addDataModelSlots();
    }

    private void addDataModelSlots() {
        int index = 0;
        for (int column = 0; column < 2; ++column) {
            for (int row = 0; row < 2; ++row) {
                this.m_38897_(new Slot(this.deepLearnerInv, index, 193 - row * 18, 82 - column * 18){

                    public boolean m_5857_(ItemStack stack) {
                        return !stack.m_41619_() && stack.m_41720_() instanceof ItemDataModel;
                    }

                    public int m_6641_() {
                        return 1;
                    }
                });
                ++index;
            }
        }
    }

    private void addInventorySlots() {
        int row;
        for (row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int x = 8 + column * 18;
                int y = 119 + row * 18;
                int index = column + row * 9 + 9;
                Slot slot = new Slot((Container)this.player.m_150109_(), index, x, y);
                this.m_38897_(slot);
            }
        }
        for (row = 0; row < 9; ++row) {
            Slot slot = new Slot((Container)this.player.m_150109_(), row, 8 + row * 18, 177);
            this.m_38897_(slot);
        }
    }

    public boolean m_6875_(Player player) {
        if (player.m_21205_().m_41720_() == ItemInit.DEEP_LEARNER.get()) {
            return true;
        }
        return player.m_21206_().m_41720_() == ItemInit.DEEP_LEARNER.get();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack retStack = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            ItemStack item = slot.m_7993_();
            retStack = item.m_41777_();
            if (index < 36 ? !this.m_38903_(item, 36, this.f_38839_.size(), true) : !this.m_38903_(item, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (item.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return retStack;
    }

    public Container getDeepInv() {
        return this.deepLearnerInv;
    }
}

